**************************************************************************************************************************************************
******************* Code for 'Does monetary policy affect non-mining business investment in Australia? evidence from BLADE' *******************
***********************************************************************************************************************

**************************************************DATE: 27 Nov 2023 ******************************************************************************
**************************************************** AUTHOR: Gulnara Nolan and Jonathan Hambur *******************************************************************
*********************************************************************************************************************************************

*** Code strcuture
*01 Baseline 
*02 Robustness
*03 Extra controls
*04 with FE
*05 IV
*06 Other shocks







adopath + ""
mata: mata mlib index
cd "$intermediate"
use bas_final3.dta, clear



tsset firmid2 period

local hmax = 16

eststo clear 

cap drop b u d Years Zero
gen Years= _n-1 if _n<=`hmax'+1
g Zero=0 if _n<=`hmax'+1
gen b=0
gen u=0
gen d=0




***************************** 01 Baseline - 
******************************Figure 1
** quarter dummeis seem really important as otherwise really vlatile SE.
eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 



eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales  , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)



************************************************************************* 02 Robustness


***************************** Baseline lag testing

****4 lags
** Note lose lots of obs
eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/4).beckers_aug l(1/4).intmargin l(0/4).gdp l(0/4).cpi l(0/4).dsales , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_4lag.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 


****4 lags
** change past int margin so zero if not
g intmargin_alt = intmargin
replace intmargin_alt = 0 if extmargin==0
eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/4).beckers_aug l(1/4).intmargin_alt l(0/4).gdp l(0/4).cpi l(0/4).dsales , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmarginalt_bas_4lag.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 



eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/4).beckers_aug l(1/4).extmargin l(0/4).gdp l(0/1).cpi l(0/4).dsales  , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_4lag.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)


******* with contemporanous macro vars 

** quarter dummeis seem really important as otherwise really vlatile SE.
eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(0/1).gdp l(0/1).cpi l(0/1).dsales , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_contemp_contr.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 



eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(0/1).gdp l(0/1).cpi l(0/1).dsales  , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_contemp_contr.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)

******* with no macro contemporanous macro vars 

** quarter dummeis seem really important as otherwise really vlatile SE.
eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).dsales , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_nomacro.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 



eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin  l(1/1).dsales  , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_contemp_nomacro.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)

***************************** 03 Extra controls

forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales l(1/1).ur l(1/1).der, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_der_ur.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 


eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales l(1/1).ur l(1/1).der , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_der_ur.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)


******* with no controls

** quarter dummeis seem really important as otherwise really vlatile SE.
eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin  , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_nocontr.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 



eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin   , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_contemp_nocontr.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)



******************************
***************04  With FE

eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales ,  cluster (period firmid2) a(fsize_ ind qr firmid2)
}

estout * using "${results}\feintmargin_bas.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 



eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales , cluster (period firmid2) a(fsize_ ind qr firmid2) 
}

estout * using "${results}\feextmargin_bas.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)



*******************************************************05 IV

****************IV testing - Appendix Figure C9 ********************************************************************************************************************************************************
eststo clear 
forv h=0/16 {
	eststo: ivregress 2sls intmargin_`h' (cr_targ_fine=beckers_aug) l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales i.fsize i.ind i.qr, cluster (period) 
}

estout * using "${results}\IVintmargin_bas.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 



eststo clear 
forv h=0/16 {
	eststo: ivregress 2sls extmargin_`h' (cr_targ_fine=beckers_aug) l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales i.ind i.fsize_ i.qr r, cluster (period ) 
}

estout * using "${results}\IVextmargin_bas.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 


** lag IV too
eststo clear 
forv h=0/16 {
	eststo: ivregress 2sls intmargin_`h' (l(0/1).cr_targ_fine=l(0/1).beckers_aug) l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales i.fsize i.ind i.qr, cluster (period )
}

estout * using "${results}\IVintmargin_bas_.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 


eststo clear 
forv h=0/16 {
	eststo: ivregress 2sls extmargin_`h' (l(0/1).cr_targ_fine=l(0/1).beckers_aug) l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales i.fsize i.ind i.qr , cluster (period ) 
}

estout * using "${results}\IVextmargin_.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)




*******************************06 Other shocks

************************************************testing with hambur shock - Eppendix FigureC10
eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).level l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if level!=0 & l.level!=0, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_level.csv"  , replace	cells(b(star) se ci_l ci_u) stats(r2 N) 


eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).level l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales  if level!=0 & l.level!=0, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_level.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)



** no gfc

gen level2=level 
replace level2=. if tsid==2009


eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).level2 l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales  if level!=0 & l.level!=0, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_level2.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 




eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).level2 l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales  if level!=0 & l.level!=0, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_level2.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)
/*


**** Beckers shock
eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_b.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 


eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_b.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)

******** just cr level
eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).cr_targ_fine l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_cr.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 


eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).cr_targ_fine l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales  , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_cr.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)
/*
*****IV with hambur shock

eststo clear 
forv h=0/16 {
	eststo: ivregress 2sls intmargin_`h' (cr_targ_fine=level) l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales i.ind i.fsize_ i.qr, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\IVintmargin_bas_level.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 



eststo clear 
forv h=0/16 {
	eststo: ivregress 2sls extmargin_`h' (cr_targ_fine=level) l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales i.ind i.fsize_ i.qr, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\IVextmargin_bas_level.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 


